<?php


class Scrapper {

    private $base_url = "https://play.google.com/store/search";
    private $document = null;

   public function __construct($lang = "tr", $keyword) {
        $this->document = new Document($this->base_url.'?q='.$keyword.'&hl='.$lang.'&c=apps', true);
    } 

    public function get_applist() {
         $data = $this->document->find("div[jsname=O2DNWb] > div[class=ImZGtf mpg5gc]");
        $gallery = [];
        $i =0;
        foreach ($data as $item) {
         $gallery[$i]['sira']= $i+1;
         $gallery[$i]['name'] = $item->first("div[class=b8cIId ReQCgd Q9MA7b]")->text();
         $app_slug = $item->first("div[class=wXUyZd] > a[href*=store] ")->attr("href");
         $gallery[$i]['app_slug'] = str_replace('/store/apps/details?id=','',$app_slug);
         $gallery[$i]['app_description'] = $item->first("div[class=b8cIId f5NCO]")->text();
         $gallery[$i]['app_image'] = $item->first("span[class=kJ9uy K3IMke buPxGf] > img[class=T75of QNCnCf]")->attr("data-src");
         $i++;
        } 
        return $gallery; 

    }
   
    public function get_title() {
        return $this->document->first("h1[class=AHFaub]")->text();
    }

    public function get_category()
    {
        return $this->document->find("div[class=ZVWMWc] > div[class=qQKdcc] > span[class=T32cc UAO9ie]")[1]->text();
    }

    public function get_category_type()
    {
        //return $this->document->find("div[class=ZVWMWc] > div[class=qQKdcc] > span[class=T32cc UAO9ie]")[1]->text();
        $text = $this->document->find("div[class=ZVWMWc] > div[class=qQKdcc] > span[class=T32cc UAO9ie] > a[href*=store]")[1]->attr("href");
        if (strpos($text, 'GAME')>0) { return 'game'; } else { return 'app';}
    }

    public function get_developer()
    {
        return $this->document->find("div[class=ZVWMWc] > div[class=qQKdcc] > span[class=T32cc UAO9ie]")[0]->text();
    }

    public function get_image()
    {
        return $this->document->first("img[class=T75of sHb2Xb]")->attr("src");
    }

    public function get_content_text()
    {
        return $this->document->first("div[jsname=sngebd]")->text();
    }

    public function get_content_html()
    {
        return $this->document->first("div[jsname=sngebd]")->html();
    }

    public function get_updated()
    {
        return $this->document->find("span[class=htlgb] > div[class=IQ1z0d] > span[class=htlgb]")[0]->text();
    }

   public function get_required()
    {
        return $this->document->find("div[class=hAyfc] > span[class=htlgb] > div[class=IQ1z0d] > span[class=htlgb]")[4]->text();
    }

   public function get_rating()
    {
        $rating = $this->document->find("div[class=K9wGie] > div[class=BHMmbe]")[0];
        if (!empty($rating)) {return $rating->text();}
    }

    public function get_size()
    {
        return $this->document->find("span[class=htlgb] > div[class=IQ1z0d] > span[class=htlgb]")[1]->text();
    }

    public function get_installs()
    {
        return $this->document->find("span[class=htlgb] > div[class=IQ1z0d] > span[class=htlgb]")[2]->text();
    }

    public function get_version()
    {
        return $this->document->find("span[class=htlgb] > div[class=IQ1z0d] > span[class=htlgb]")[3]->text();
    }

    public function get_editor_choice()
    {
        return $this->document->has("span[class=giozf]") ? 1 : 0;
    }

    public function get_video()
    {
        return count($element = $this->document->first('button[class=lgooh  ]')) > 0 ? $element->attr("data-trailer-url") : "Not Found";
    }

    public function get_gallery()
    {
        $data = $this->document->find("button[class=Q4vdJd] > img[itemprop=image]");
        $gallery = [];
        foreach ($data as $item) {
            if (!empty($item->attr("data-srcset"))) {
                $gallery[] = str_replace(' 2x','',$item->attr("data-srcset"));
            } else {
                $gallery[] = $item->attr("src");
            }
        }
        return $gallery;
    }

    public function get_price()
    {
        return $this->document->first("button[class=LkLjZd ScJHi HPiPcc IfEcue  ]")->attr("aria-label");
    }

    public function get_comment()
    {
        $data = $this->document;

        return $data;
    }
}
